#import "MyApplication.h"

@implementation MyApplication

-(void)awakeFromNib {	
	aboutWindowController = nil;
	tabViewController = nil;
}

-(IBAction)orderFrontStandardAboutPanel:(id)sender{
	if(aboutWindowController == nil){
			
		aboutWindowController = [[AboutWindowController alloc]
							initWithWindowNibName: @"MyAbout"];
	}
	[aboutWindowController showWindow:self];
}

-(void)tabView:(NSTabView*)tabView didSelectTabViewItem:(NSTabViewItem*)tabViewItem {
	
	NSString*	identifier = [tabViewItem identifier];
	BOOL		switches = NO;
	if([identifier isEqualToString:@"2"]){
		if(tabViewController == nil){
			tabViewController = [[MyTabViewController alloc]
							initWithWindowNibName: @"TabView"];
			[tabViewController setTarget:self];
			[tabViewItem setView:[[tabViewController window] contentView]];
		}
		switches = YES;
	}
	[button1Sw setEnabled:switches];
	[button2Sw setEnabled:switches];
	[button3Sw setEnabled:switches];
}

- (IBAction)toggleButton1:(id)sender {
	
	[[tabViewController button1] setEnabled:(BOOL)([sender state] == NSOnState)];
	
}

- (IBAction)toggleButton2:(id)sender {
	
	[[tabViewController button2] setEnabled:(BOOL)([sender state] == NSOnState)];

}

- (IBAction)toggleButton3:(id)sender {

	[[tabViewController button3] setEnabled:(BOOL)([sender state] == NSOnState)];

}


- (void)button1:(id)sender {

	NSLog(@"button1 pressed.");
}

- (void)button2:(id)sender {
	
	NSLog(@"button2 pressed.");
}

- (void)button3:(id)sender {
	
	NSLog(@"button3 pressed.");
}




@end
