#import "MyApplication.h"

/*
@implementation NSTextView (MOSA)

- (void) printDocument:(id)sender {
	
	[self print:sender];
}
@end
*/

@implementation MyApplication

- (void)finishLaunching{

	[super finishLaunching];
	
	NSToolbar*	aToolBar = [[[NSToolbar alloc] initWithIdentifier:@"MOSA_SAMPLE"] autorelease];
	
	toolbarItems = [[NSMutableDictionary alloc] initWithCapacity:0];

	NSToolbarItem*	catItem = [[[NSToolbarItem alloc] initWithItemIdentifier:@"Cat"] autorelease];
	[catItem setLabel:@"Cat"];
	[catItem setPaletteLabel:@"Cat"];
	[catItem setToolTip:@"Type 'Cat'"];
	[catItem setImage:[NSImage imageNamed:@"Cat.tif"]];
	
	[catItem setTarget:self];
	[catItem setAction:@selector(typeCat:)];
	
	[toolbarItems setObject:catItem forKey:@"Cat"];
	
	NSToolbarItem*	alignPop = [[[NSToolbarItem alloc] initWithItemIdentifier:@"Align"] autorelease];
	[alignPop setLabel:@"Align Text"];
	[alignPop setPaletteLabel:@"Align Text"];
	[alignPop setToolTip:@"Align Text"];
	
	NSMenuItem*		alignPopItem = [[[NSMenuItem alloc] init] autorelease];
	[alignPopItem setSubmenu:[alignPopUpButton menu]];
	[alignPopItem setTitle:@"Align Text"];
	[alignPop setMenuFormRepresentation:alignPopItem];
	
	[alignPop setView:sampleView];
	
	[toolbarItems setObject:alignPop forKey:@"Align Text"];

	[aToolBar setDelegate:self];
	
	[aToolBar setAllowsUserCustomization:YES];
	[aToolBar setAutosavesConfiguration:YES];
	
	[window setToolbar:aToolBar];
	
}

- (void)typeCat:(id)sender {
	
	[report insertText:@"Cat\r"];
}

- (NSToolbarItem*)toolbar:(NSToolbar*)toolbar 
	itemForItemIdentifier:(NSString*)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag {
	
//	return [[[toolbarItems objectForKey:itemIdentifier] copy] autorelease];
	
	NSToolbarItem*	newItem = [[[NSToolbarItem alloc] 
						initWithItemIdentifier:itemIdentifier] autorelease];
	NSToolbarItem*	anItem = [toolbarItems objectForKey:itemIdentifier];
	
	[newItem setLabel:[anItem label]];
	[newItem setPaletteLabel:[anItem paletteLabel]];
	
	if([anItem view] != NULL){
		[newItem setView:[anItem view]];
	}else{
		[newItem setImage:[anItem image]];
	}
    [newItem setToolTip:[anItem toolTip]];
    [newItem setTarget:[anItem target]];
    [newItem setAction:[anItem action]];
    [newItem setMenuFormRepresentation:[anItem menuFormRepresentation]];
	
    if ([newItem view] != NULL){
		[newItem setMinSize:[[anItem view] bounds].size];
		[newItem setMaxSize:[[anItem view] bounds].size];
    }
    return newItem;
}


- (NSArray*) toolbarDefaultItemIdentifiers: (NSToolbar*) inToolbar {
	
	return  [NSArray arrayWithObjects:
		@"Cat",
		NSToolbarSeparatorItemIdentifier,
		NSToolbarShowColorsItemIdentifier,
		NSToolbarSpaceItemIdentifier,
		NSToolbarShowFontsItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarPrintItemIdentifier,
		@"Align Text",nil]; 				
}

- (NSArray*) toolbarAllowedItemIdentifiers: (NSToolbar*) inToolbar {
	
	return  [NSArray arrayWithObjects:
		@"Cat",
		NSToolbarSeparatorItemIdentifier,
		NSToolbarShowColorsItemIdentifier,
		NSToolbarSpaceItemIdentifier,
		NSToolbarShowFontsItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarPrintItemIdentifier,
		@"Align Text",nil]; 				
}

- (void) toolbarWillAddItem:(NSNotification*)notification {
	
	NSToolbarItem*	item = [[notification userInfo] objectForKey:@"item"];
	
	if([[item itemIdentifier] isEqualToString:NSToolbarPrintItemIdentifier] == YES){
		[item setAction:@selector(print:)];
	}
}

@end
