# -*- mode:ruby; indent-tabs-mode:nil; coding:utf-8 -*-

require 'test/unit'
require 'yahoo-honyaku'

class TestYahooHonyaku < Test::Unit::TestCase
  # インスタンスメソッド YahooHonyaku#translate のテスト
  def test_translate
    translator = YahooHonyaku.new

    assert_equal("Good morning",
                 translator.translate(:je, "おはよう"),
                 "和英翻訳の動作確認")
    assert_equal("おはよう",
                 translator.translate(:ej, "Good morning"),
                 "英和翻訳の動作確認")

    assert_equal("早上好",
                 translator.translate(:jc, "おはよう"),
                 "日中翻訳の動作確認")
    assert_equal("おはようございます",
                 translator.translate(:cj, "早上好"),
                 "中日翻訳の動作確認")

    assert_equal("안녕하세요",
                 translator.translate(:jk, "こんにちは"),
                 "日韓翻訳の動作確認")
    assert_equal("こんにちは",
                 translator.translate(:kj, "안녕하세요"),
                 "韓日翻訳の動作確認")
  end

  # クラスメソッド YahooHonyaku.translate のテスト
  def test_s_translate
    assert_equal("Good morning", 
                 YahooHonyaku.translate(:je, "おはよう"),
                 "和英翻訳の動作確認")
    assert_equal("おはよう", 
                 YahooHonyaku.translate(:ej, "Good morning"),
                 "英和翻訳の動作確認")
  end
end
