# -*- mode:ruby; indent-tabs-mode:nil; coding:utf-8 -*-

class YahooHonyaku
  require 'cgi'
  require 'rubygems'
  require 'rest-open-uri'
  require 'hpricot'

  def self.translate(mode, text)
    new.translate(mode, text)
  end
  
  def translate(mode, text)
    open_top_page unless top_page_opened?
    html = post_text(mode, text)
    parse_result(html)
  end

  private

  URL = "http://honyaku.yahoo.co.jp/"
  HTTP_REQUEST_HEADER = {
    "User-Agent"     => "Mozilla/5.0",
    "Accept-Charset" => "UTF-8"
  }

  def open_top_page
    html = open(URL, HTTP_REQUEST_HEADER) { |io| io.read }
    parse_form!(html)
    @top_page_opened = true
  end

  def top_page_opened?
    @top_page_opened ? true : false
  end

  def _eid_(mode)
    mode = mode.to_s.upcase
    case mode
    when "JC" then "CR-JC-CN"
    else           "CR-#{mode}"
    end
  end

  def post_text(mode, text)
    params = {
      :eid  => _eid_(mode),  # 変換モード(_eid_で正規化)
      :text => text,         # 翻訳したいテキスト
      :key  => @key,         # HTTPレスポンスから取得した値
      :time => @time,        # HTTPレスポンスから取得した値
      :both => "TH"          # (謎のパラメータ、おまじない)
    }
    body = params.map{ |key, val|
      "#{key}=#{CGI.escape(val.to_s)}" }.join('&')
    request = HTTP_REQUEST_HEADER.merge(
      "Content-Type" => "application/x-www-form-urlencoded")

    request[:method] = :post   # rest-open-uriで拡張された機能
    request[:body]   = body    # rest-open-uriで拡張された機能
    open(URL, request) { |io| io.read }
  end

  def parse_html!(html)
    doc = Hpricot(html)
    @form = doc.search("form[@name=textFormEntry]")[0]
    @key  = @form.search("input[@name=key]")[0]["value"]
    @time = @form.search("input[@name=time]")[0]["value"]
    if @form.nil? or @key.nil? or @time.nil? 
      raise "Yahoo翻訳の返すHTMLのパースに失敗しました"
    end
    # 翻訳されたテキストを返す
    @form.search("textarea[@name=trn_text]").text
  end
  alias parse_result parse_html!
  alias parse_form!  parse_html!
end
